﻿// Если нужен контроль, устанавливаем флаг в процессе, записываем роль для контроля
if (this.Signal.NeedControl)
{
	this.Process.NeedControl = true;
	this.Process.ControlRole.ID = (Guid?) this.Signal.RoleID ?? Session.User.ID; 
	this.Process.ControlRole.Name = (string) this.Signal.RoleName ?? Session.User.Name; 
}

// Проверяем, заданы ли роли
var nextRoles = this.SignalHash.Get<IList>("NextRoles");
if (nextRoles is not { Count: > 0 })
{
	this.ValidationResult.AddError(this, "$WfResolution_Error_CantObtainPerformers");
	return;
}

var durationInDays = (double?) this.Signal.DurationInDays;
var planned = (DateTime?) this.Signal.Planned;

// Проверки заполнения полей
if (durationInDays.HasValue
	&& durationInDays.Value <= 0)
{
	this.ValidationResult.AddError(this, "$WfResolution_Error_TaskDurationCantBeZeroOrNegative");
	return;
}

if (!durationInDays.HasValue
	&& !planned.HasValue)
{
	this.ValidationResult.AddError(this, "$WfResolution_Error_ResolutionHasNoPlannedDate");
	return;
}

// Установка плановой даты завершения, срока и комментария
this.Process.Planned = planned;
this.Process.DurationInDays = durationInDays;
this.Process.Comment = this.Signal.Comment;

var parentUserName = this.Session.User.Name;

// Если должно отправиться одно задание, в качестве роли исполнителя получаем одну агрегатную роль
if (this.Signal.SingleTask)
{	
	this.Signal.MajorPerformer = false;
	this.Process.Roles = await AggregateRolesAsync(nextRoles);
	this.Process.TasksCount = 1;
}
else
{
	// Если ролей несколько и есть флаг Ответственный исполнитель, то в качестве ролей для данного задания берем первого
	// и обновляем комментарий
	if (nextRoles.Count > 1
		&& (bool)Signal.MajorPerformer)
	{
		this.Process.Roles = nextRoles.Cast<object>().Take(1).ToList();
		this.Process.TasksCount = 1;
		var processComment = (string) this.Process.Comment;		
		this.Process.Comment = 
			string.IsNullOrEmpty(processComment)
						? string.Format(
							LocalizeAndEscapeFormat("$WfResolution_Digest_MajorPerformerWithoutComment"),
							parentUserName)
						: string.Format(
							LocalizeAndEscapeFormat("$WfResolution_Digest_MajorPerformer"),
							parentUserName,
							processComment);
		
		nextRoles.RemoveAt(0);
	}
	else // иначе просто берем все указанные роли, записываем число отправленных заданий
	{
		this.Process.Roles = nextRoles;
		this.Process.TasksCount = nextRoles.Count;	
	}
}

// Если происходит отправка дочерних при отправке с флагом Первый ответственный, то обновляем ему комментарий
if ((bool?) this.Signal.MinorPerformer ?? false)
{
	var roleName = 
		WorkflowEngineHelper.Get<string>(
			(Dictionary<string, object>)nextRoles[0],
			"Role", "Name");	
			
	var comment = (string) this.Signal.Comment;
	
	this.Process.Comment = 
		string.IsNullOrEmpty(comment)
				? string.Format(
					LocalizeAndEscapeFormat("$WfResolution_Digest_CoperformerWithoutComment"),
					parentUserName,
					roleName)
				: string.Format(
					LocalizeAndEscapeFormat("$WfResolution_Digest_Coperformer"),
					parentUserName,
					roleName,
					comment);
}

// Если задан автор, указываем его в действии задания
if (this.Signal.AuthorID != null)
{
	this.Process.Author.ID = (Guid) this.Signal.AuthorID;
	this.Process.Author.Name = (string) this.Signal.AuthorName;
}
